<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('X-Content-Type-Options: nosniff');

$artist = trim((string)($_GET['artist'] ?? ''));
$title  = trim((string)($_GET['title'] ?? ''));
$fallback = (string)($_GET['fallback'] ?? '');
$logo = (string)($_GET['logo'] ?? '');

function http_get(string $url): ?string {
  $ch = curl_init();
  curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_CONNECTTIMEOUT => 4,
    CURLOPT_TIMEOUT => 6,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false,
    CURLOPT_USERAGENT => 'CoverLookup/1.0'
  ]);
  $out = curl_exec($ch);
  $code = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);
  if($out === false || $code >= 400) return null;
  return $out;
}

$term = trim($artist . ' ' . $title);
$image = null;
if($term !== ''){
  $api = 'https://itunes.apple.com/search?entity=song&limit=1&term='.rawurlencode($term);
  $json = http_get($api);
  if($json){
    $j = json_decode($json,true);
    if($j && isset($j['results'][0]['artworkUrl100'])){
      $art = $j['results'][0]['artworkUrl100'];
      $image = str_replace('100x100bb','600x600bb',$art);
    }
  }
}
if(!$image && $fallback){ $image = $fallback; }
if(!$image && $logo){ $image = $logo; }

echo json_encode(['image'=>$image], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
