<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('X-Content-Type-Options: nosniff');

$stream = $_GET['stream'] ?? '';
$type   = $_GET['type']   ?? '';
$mount  = $_GET['mount']  ?? '';

if(!$stream){
  http_response_code(400);
  echo json_encode(['error'=>'missing stream']); exit;
}

function http_get(string $url): ?string {
  $ch = curl_init();
  curl_setopt_array($ch, [
    CURLOPT_URL => $url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_CONNECTTIMEOUT => 4,
    CURLOPT_TIMEOUT => 6,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false,
    CURLOPT_USERAGENT => 'RadioMeta/1.0 (+metadata)'
  ]);
  $out = curl_exec($ch);
  $code = (int)curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);
  if($out === false || $code >= 400) return null;
  return $out;
}

function parse_host_port(string $url): array {
  if (strpos($url,'http') !== 0) $url = 'http://' . ltrim($url,'/');
  $p = parse_url($url);
  return [$p['scheme']??'http', $p['host']??'', $p['port']??null];
}

function try_icecast(string $stream, string $mount): ?array {
  [$scheme,$host,$port] = parse_host_port($stream);
  if(!$host) return null;
  $base = $scheme.'://'.$host.($port?(':'.$port):'');
  $status = http_get($base.'/status-json.xsl');
  if(!$status) return null;
  $j = json_decode($status,true);
  if(!isset($j['icestats'])) return null;
  $src = $j['icestats']['source'] ?? null;
  if(!$src) return null;
  $sources = is_array($src) && isset($src[0]) ? $src : [$src];
  $chosen = null;
  if($mount){
    foreach($sources as $s){
      if(isset($s['listenurl']) && str_contains($s['listenurl'],$mount)) { $chosen = $s; break; }
      if(isset($s['server_name']) && str_contains((string)$s['server_name'],$mount)) { $chosen = $s; break; }
    }
  }
  if(!$chosen) $chosen = $sources[0];
  if(!$chosen) return null;
  $title = $chosen['title'] ?? ($chosen['artist']??null);
  $artist = $chosen['artist'] ?? null;
  if(!$artist && $title && str_contains($title,' - ')){
    [$artist,$t] = explode(' - ', $title, 2);
    $title = $t;
  }
  return [
    'server' => 'icecast',
    'title' => $title ?: null,
    'artist'=> $artist ?: null,
    'listeners' => $chosen['listeners'] ?? null,
  ];
}

function try_shoutcast(string $stream, string $mount): ?array {
  [$scheme,$host,$port] = parse_host_port($stream);
  if(!$host) return null;
  $base = $scheme.'://'.$host.($port?(':'.$port):'');
  $sid = 1;
  if($mount && preg_match('/sid=(\d+)/',$mount,$m)){ $sid = (int)$m[1]; }
  $stats = http_get($base.'/stats?json=1');
  if(!$stats) $stats = http_get($base.'/stats?sid='.$sid.'&json=1');
  if($stats){
    $j = json_decode($stats,true);
    if(isset($j['streams'])){
      $s = $j['streams'][$sid] ?? reset($j['streams']);
      $song = $s['songtitle'] ?? ($s['title']??null);
      $artist = null; $title = $song;
      if($song && str_contains($song,' - ')){
        [$artist,$title] = explode(' - ', $song, 2);
      }
      return [
        'server'=>'shoutcast',
        'title'=>$title ?: null,
        'artist'=>$artist ?: null,
        'listeners'=>$s['currentlisteners'] ?? null,
      ];
    }
  }
  $curr = http_get($base.'/currentsong?sid='.$sid);
  if(!$curr) $curr = http_get($base.'/7.html');
  if($curr){
    $line = trim(strip_tags($curr));
    if(str_contains($curr,',')){
      $parts = explode(',', $curr);
      $song = $parts[6] ?? '';
    } else {
      $song = $line;
    }
    $artist = null; $title = $song;
    if($song && str_contains($song,' - ')){
      [$artist,$title] = explode(' - ', $song, 2);
    }
    return ['server'=>'shoutcast','title'=>$title?:null,'artist'=>$artist?:null];
  }
  return null;
}

function try_icy(string $stream): ?array {
  $ch = curl_init();
  curl_setopt_array($ch, [
    CURLOPT_URL => $stream,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_CONNECTTIMEOUT => 5,
    CURLOPT_TIMEOUT => 10,
    CURLOPT_SSL_VERIFYPEER => false,
    CURLOPT_SSL_VERIFYHOST => false,
    CURLOPT_USERAGENT => 'RadioMeta/1.0 (+icy)',
    CURLOPT_HTTPHEADER => ['Icy-MetaData: 1'],
    CURLOPT_NOBODY => false,
    CURLOPT_HEADER => false,
  ]);
  $data = curl_exec($ch);
  if($data === false){
    curl_close($ch);
    return null;
  }
  if(preg_match("/StreamTitle='([^']+)'/i", $data, $m)){
    $song = trim($m[1]);
    $artist = null; $title = $song;
    if(strpos($song,' - ') !== false){
      [$artist,$title] = explode(' - ', $song, 2);
    }
    curl_close($ch);
    return ['server'=>'icy','title'=>$title?:null,'artist'=>$artist?:null];
  }
  curl_close($ch);
  return null;
}

$meta = null;
if($type === 'icecast'){
  $meta = try_icecast($stream,$mount);
}elseif($type === 'shoutcast'){
  $meta = try_shoutcast($stream,$mount);
}else{
  $meta = try_icecast($stream,$mount) ?? try_shoutcast($stream,$mount) ?? try_icy($stream);
}

echo json_encode($meta ?: ['title'=>null,'artist'=>null], JSON_UNESCAPED_UNICODE);
