<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$url = $_GET['url'] ?? '';
if(!$url){
  http_response_code(400); echo json_encode(['error'=>'missing url']); exit;
}
parse_str(parse_url($url, PHP_URL_QUERY) ?? '', $q);
$layout = $q['layout'] ?? 'square';
$size   = $q['size'] ?? 'md';
$name   = $q['name'] ?? 'Radio Online';
$thumb  = $q['fallback'] ?? '';

function dims($layout, $size){
  $map = [
    'square' => ['sm'=>[320,520], 'md'=>[420,560], 'lg'=>[560,640], 'lx'=>[900,800]],
    'vertical'=>['sm'=>[360,640], 'md'=>[420,760], 'lg'=>[480,900], 'lx'=>[600,1280]],
    'horizontal'=>['sm'=>[560,360], 'md'=>[640,420], 'lg'=>[760,480], 'lx'=>[1080,620]],
    'round'  => ['sm'=>[320,520], 'md'=>[420,560], 'lg'=>[560,640], 'lx'=>[900,800]],
  ];
  if(isset($map[$layout][$size])) return $map[$layout][$size];
  return [420,560];
}
[$width,$height] = dims($layout,$size);
$html = '<iframe src="'.htmlspecialchars($url, ENT_QUOTES).'" width="'.$width.'" height="'.$height.'" frameborder="0" allow="autoplay" loading="lazy"></iframe>';

echo json_encode([
  'version' => '1.0',
  'type' => 'rich',
  'provider_name' => 'RadioPlayer',
  'provider_url' => (function(){
    $https = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https');
    $scheme = $https ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
    return $scheme.'://'.$host;
  })(),
  'title' => $name.' — En vivo',
  'thumbnail_url' => $thumb,
  'width' => $width,
  'height' => $height,
  'html' => $html
], JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE);
