<?php
declare(strict_types=1);
header('X-Frame-Options: SAMEORIGIN');

$stream = $_GET['stream'] ?? '';
$name   = $_GET['name']   ?? 'Mi Radio';
$type   = $_GET['type']   ?? ''; // icecast|shoutcast|'' auto
$mount  = $_GET['mount']  ?? '';
$fallback = $_GET['fallback'] ?? '';
$logo = $_GET['logo'] ?? '';
$accent = $_GET['accent'] ?? '#1f6feb';
$layout = $_GET['layout'] ?? 'square'; // square|vertical|horizontal|round
$size   = $_GET['size']   ?? 'md';     // sm|md|lg|lx
$enhance= isset($_GET['enhance']) ? (int)$_GET['enhance'] : 1; // 1=on (no toggle button)
$notitle= $_GET['notitle'] ?? 'En vivo';

if (!$stream) { http_response_code(400); echo 'Falta el parámetro "stream".'; exit; }

function h($s){ return htmlspecialchars($s ?? '', ENT_QUOTES,'UTF-8'); }
function absolute_url(): string {
  $https = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') || (isset($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https');
  $scheme = $https ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
  $uri = $_SERVER['REQUEST_URI'] ?? '/';
  return $scheme . '://' . $host . $uri;
}
$canonical = absolute_url();
$desc = $name . ' — Radio en vivo. Reproductor con carátula y metadata.';
$img = $fallback ?: ($logo ?: 'https://via.placeholder.com/600x600.png?text=Radio+Cover');
?>
<!doctype html>
<html lang="es">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php echo h($name); ?> - Player</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;800&display=swap" rel="stylesheet">
<link rel="stylesheet" href="assets/styles.css">
<style>:root{ --accent: <?php echo h($accent); ?>; }</style>

<!-- Open Graph / Twitter Cards -->
<meta property="og:title" content="<?php echo h($name); ?> — En vivo">
<meta property="og:description" content="<?php echo h($desc); ?>">
<meta property="og:type" content="music.radio_station">
<meta property="og:url" content="<?php echo h($canonical); ?>">
<meta property="og:image" content="<?php echo h($img); ?>">

<meta name="twitter:card" content="player">
<meta name="twitter:title" content="<?php echo h($name); ?> — En vivo">
<meta name="twitter:description" content="<?php echo h($desc); ?>">
<meta name="twitter:image" content="<?php echo h($img); ?>">
<meta name="twitter:player" content="<?php echo h($canonical); ?>">
<meta name="twitter:player:width" content="640">
<meta name="twitter:player:height" content="420">

<!-- oEmbed discovery -->
<link rel="alternate" type="application/json+oembed" href="api/oembed.php?url=<?php echo rawurlencode($canonical); ?>" title="<?php echo h($name); ?>">

</head>
<body class="player-body layout-<?php echo h($layout); ?> size-<?php echo h($size); ?>">
  <div class="player-card">
    <div class="header">
      <div class="branding">
        <?php if ($logo) { ?><img class="logo" src="<?php echo h($logo); ?>" alt="Logo"><?php } else { ?><div class="dot"></div><?php } ?>
        <div class="titles">
          <h1 class="station"><?php echo h($name); ?></h1>
          <p class="now">Ahora suena</p>
        </div>
      </div>
    </div>

    <div class="cover-wrap">
      <img id="cover" src="<?php echo h($fallback ?: ($logo ?: 'https://via.placeholder.com/600x600.png?text=Radio')); ?>" alt="Portada" loading="lazy">
      <div class="glow"></div>
      <button class="play" id="playBtn" aria-label="Reproducir/Pausar">▶</button>
    </div>

    <div class="meta">
      <div class="corner-tools">
        <button class="icon-mini ico-open" id="openPopup" aria-label="Abrir en ventana" title="Abrir en ventana">
          <svg viewBox="0 0 24 24" width="18" height="18" xmlns="http://www.w3.org/2000/svg"><path d="M14 3h7v7h-2V6.414l-9.293 9.293-1.414-1.414L17.586 5H14V3z" fill="#cfe3ff"/><path d="M19 19H5V5h6V3H5a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-6h-2v6z" fill="#9fb4cc"/></svg>
        </button>
        <?php $encUrl = rawurlencode($canonical); $encText = rawurlencode($name.' — En vivo'); ?>
        <a class="icon-mini ico-fb" aria-label="Facebook" title="Facebook" target="_blank" rel="noopener" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo $encUrl; ?>">
          <svg viewBox="0 0 24 24" width="18" height="18" xmlns="http://www.w3.org/2000/svg"><rect x="2" y="2" width="20" height="20" rx="4" fill="#1877F2"/><path d="M13.5 8h2V5.5h-2c-2.2 0-3.5 1.3-3.5 3.5V11H8v2.5h2v5h2.5v-5H15L15.5 11H12v-1.8c0-.8.2-1.2 1.5-1.2z" fill="#fff"/></svg>
        </a>
        <a class="icon-mini ico-x" aria-label="X" title="X" target="_blank" rel="noopener" href="https://twitter.com/intent/tweet?url=<?php echo $encUrl; ?>&text=<?php echo $encText; ?>">
          <svg viewBox="0 0 24 24" width="18" height="18" xmlns="http://www.w3.org/2000/svg"><rect x="2" y="2" width="20" height="20" rx="4" fill="#0F1419"/><path d="M6 6l5.7 7.6L6.6 18h2.2l3.7-3.2 2.8 3.2H18l-6-8 3.9-3.8h-2.2l-3.2 2.8L8 6H6z" fill="#fff"/></svg>
        </a>
        <a class="icon-mini ico-wa" aria-label="WhatsApp" title="WhatsApp" target="_blank" rel="noopener" href="https://wa.me/?text=<?php echo $encText; ?>%20<?php echo $encUrl; ?>">
          <svg viewBox="0 0 24 24" width="18" height="18" xmlns="http://www.w3.org/2000/svg"><path d="M20.52 3.48A11.5 11.5 0 003.48 20.52L2 22l1.7-.44A11.5 11.5 0 1011.99 1.5c3.07 0 5.94 1.2 8.08 3.34z" fill="#25D366"/><path d="M17.5 14.2c-.2-.11-1.18-.58-1.36-.65-.18-.07-.32-.1-.45.11-.13.2-.51.65-.62.78-.11.13-.23.15-.42.05-.2-.11-.84-.31-1.6-.98-.59-.53-1.98-2.19-1.1-1.39.11-.2-.01-.31.1-.41.1-.1.2-.23.31-.35.1-.12.13-.2.2-.33.07-.13.04-.25-.02-.35-.06-.1-.45-1.08-.62-1.48-.16-.39-.33-.33-.45-.33h-.39c-.13 0-.34.05-.52.25-.18.2-.69.67-.69 1.62s.71 1.87.81 2.01c.1.13 1.39 2.13 3.38 2.99.47.2.83.32 1.12.41.47.15.9.13 1.24.08.38-.05 1.18-.48 1.35-.95.17-.47.17-.88.12-.95-.05-.07-.18-.11-.38-.22z" fill="#fff"/></svg>
        </a>
      </div>

      <div class="track" id="track">Cargando…</div>
      <div class="artist" id="artist"></div>
    </div>

    <div class="controls">
      <button class="btn" id="muteBtn" title="Silenciar">🔇</button>
      <input type="range" id="volume" min="0" max="1" step="0.01" value="1" aria-label="Volumen">
    </div>

    <audio id="audio" src="<?php echo h($stream); ?>" preload="none" autoplay playsinline crossorigin="anonymous"></audio>
  </div>

<script>
const CONFIG = {
  stream: <?php echo json_encode($stream, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE); ?>,
  name:   <?php echo json_encode($name, JSON_UNESCAPED_UNICODE); ?>,
  type:   <?php echo json_encode($type, JSON_UNESCAPED_UNICODE); ?>,
  mount:  <?php echo json_encode($mount, JSON_UNESCAPED_UNICODE); ?>,
  fallback: <?php echo json_encode($fallback, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE); ?>,
  logo: <?php echo json_encode($logo, JSON_UNESCAPED_SLASHES|JSON_UNESCAPED_UNICODE); ?>,
  layout: <?php echo json_encode($layout, JSON_UNESCAPED_UNICODE); ?>,
  size:   <?php echo json_encode($size, JSON_UNESCAPED_UNICODE); ?>,
  enhance:<?php echo json_encode((bool)$enhance); ?>,
  notitle:<?php echo json_encode($notitle, JSON_UNESCAPED_UNICODE); ?>,
};
</script>
<script src="assets/player.js"></script>
</body>
</html>
